  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_AesKeyAsymAuthenticator.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_AesKeyAuthTestDataStruct* TST_ATP_AesKeyAuthObjectTestData;

/************************ Public Functions *********************/
/*****************************************************************************
* Function Name:
*  SST_TST_ATP_AesKeyAsymAuthenticator
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the creation, deletion, modification, opening, closing and usage of a shared key authenticator object.
* And demonstration on the use of transaction with authenticator objects
*  
* Algorithm:
*     1.  Create a new session by calling: SST_SessionCreate.
*     2.  Open a transaction by calling: SST_TransactionStart.
*     3.  Create a new asymmetric key authenticator by calling: SST_AuthenticatorAESSharedSecretCreate.
*     4.  Close the transaction by calling: SST_TransactionClose.
*     5.  Open a transaction by calling: SST_TransactionStart.
*     6.  Open the new authenticator by calling: 
*          i.   SST_AuthenticatorChallengeGet 
*          ii.  CRYS_AES (Encrypt the challenge using the AES key)
*          iii. SST_AuthenticationOpen.
*     7.  Close the transaction by calling: SST_TransactionClose.
*     8.  Open a transaction by calling: SST_TransactionStart.
*     9.  Insert a new data object by calling: SST_InsertData.
*     10. Close the authenticator by calling: SST_AuthenticationClose.
*     11. Open the new authenticator by calling: 
*          i.   SST_AuthenticatorChallengeGet 
*          ii.  CRYS_AES (Encrypt the challenge using the AES key)
*          iii. SST_AuthenticationOpen.
*     12.Close the transaction by calling: SST_TransactionClose.
*     13.Open a transaction by calling: SST_TransactionStart.
*     14.Delete the data by calling: SST_DeleteData.
*     15.Close the authenticator by calling: SST_AuthenticationClose.
*     16.Delete the authenticator by calling: SST_AuthenticatorDelete.
*     17.Close the transaction by calling: SST_TransactionClose.
*     18.Delete the session by calling: SST_SessionDelete.
* 
*******************************************************************************/
DxError_t SEPQA_SST_AesKeyAsymAuthenticator ( void )
{
    /******** TST Variables Definitions ************/
    DxUint32_t                  TST_index=0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_AesKeyAsymAuthenticator";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_DataHandle;
    SSTChallengeId_t            TST_ChallengeId;
    SSTDataType_t               TST_SimpleData = TST_DATA_OBJECT;
    DxError_t                   TST_Status;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;


    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ********** SEPQA_SST_AesKeyAsymAuthenticator Tests *************** \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));

    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new AES shared key authenticator */
    /*-------------------------------------------*/
    TST_Status = SST_AuthenticatorAESSharedSecretCreate(TST_TransactionId,
                                                        TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_AesKey,
                                                        SST_KEY_TYPE_AES_128_BIT,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorAESSharedSecretCreate",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the authentication */
    /*-------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Encrypt the challenge using the AES key */
    TST_Status = CRYS_AES(DX_NULL,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_AesKey,
                          CRYS_AES_Key128BitSize,
                          CRYS_AES_Encrypt,
                          CRYS_AES_ECB_mode,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_ChallengeBuff,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_ChallengeBuffSize,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuff);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuff,
                                        TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Insert a new Data object */
    /*--------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId,
                                TST_AuthHandle,
                                TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Data,
                                TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_DataSize,
                                DX_TRUE,
                                TST_SimpleData,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);



    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Re-open the authentication */
    /*----------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_NewChallengeBuff,
                                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_NewChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Encrypt the challenge using the AES key */
    TST_Status = CRYS_AES(DX_NULL,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_AesKey,
                          CRYS_AES_Key128BitSize,
                          CRYS_AES_Encrypt,
                          CRYS_AES_ECB_mode,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_NewChallengeBuff,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_NewChallengeBuffSize,
                          TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuff);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuff,
                                        TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_EncChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* re-open a transaction for operations */
    /*--------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the data */
    /*-----------------*/
     TST_Status = SST_DataDelete(TST_TransactionId,
                                 TST_SessionId,
                                 TST_DataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TST_ATP_AesKeyAuthObjectTestData[TST_index].TST_Name,
                               TST_MasterTestName);


  EXIT_ON_ERROR:
    return TST_Status;
}/* End of SST_TST_ATP_AesKeyAsymAuthenticator */




